# 二进制日志

Joe 想要给 goods 数据库加上二进制日志，将其保存到 `/data/log/mysql/goods/binlog`。他需要执行下列哪些操作？

1. 执行shell命令 `mkdir -p /data/log/mysql/goods/binlog`
2. 编辑 my.cnf 的 \[mysqld\]节，设置
    ```
    log_bin = /data/log/mysql/goods/binlog
    binlog_format= mixed
    binlog_cache_size=32m
    max_binlog_cache_size=64m
    max_binlog_size=512m
    expire_logs_days = 10
    ```
3. 重启 MySQL 服务
4. 备份数据库
5. 恢复数据库


<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```
1, 2, 3
```

## 选项

### A

```
1, 2, 3, 4, 5
```

### B

```
1, 2, 4, 5
```

### C

```
1, 2
```